
#MAXFILESIZE=15000000
MAXFILESIZE = 0 #no limit

#these are just initial values
MID_OUT = "MIDI" 
MID_IN = "MIDI"

# Don't change anything below this line
import os
import sys
PROGRAMVERSION = "2.1.6"
PROGRAMDATE = "20140425"
ALLOWED_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789._-"

try:
    import rtmidi
    import time
    ENABLE_MIDI = True
except ImportError:
    ENABLE_MIDI = False

if ENABLE_MIDI:
    PROGRAMVERSION += " (with MIDI I/O support)"

CFG = 'dxtxmidi.cfg'
for pth in sys.path:
    s = os.path.join(pth, CFG)
    if os.path.exists(s):
        CFG = s
        break

LINUX = False
if ENABLE_MIDI and rtmidi.API_LINUX_ALSA in rtmidi.get_compiled_api():
    LINUX = True

def list2string(l):
    s = ''
    for k in l:
        if k not in list(range(128)):
            k = 32
        s += chr(k)
    return s

def string2list(s):
    l = []
    for k in s:
        l.append(ord(k))
    return l

def range2list(s):
    l = []
    s = s.split(',')
    for k in s:
        if '-' in k:
            start = max(1, int(k.split('-')[0]))
            end = int(k.split('-')[1]) + 1
            l += list(range(start, end))
        else:
            l.append(int(max(1, k)))
    return l

def checksum(data):
    return (128-sum(data)&127)%128

def nr2note(nr, C3 = 60):
    scl = ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B')
    n = (nr - C3) % 12
    i = (nr - C3) // 12 
    return scl[n] + str(i + 3) 

def id_mid_out(mid_out=MID_OUT):
    mid_out_id = -1
    midi_out = rtmidi.MidiOut()
    for i in range(midi_out.get_port_count()):
        n = midi_out.get_port_name(i)
        if mid_out.lower() in n.lower():
            mid_out_id = i
            break
    del midi_out
    return mid_out_id

def id_mid_in(mid_in = MID_IN):
    mid_in_id = -1
    midi_in = rtmidi.MidiIn()
    for i in range(midi_in.get_port_count()):
        n = midi_in.get_port_name(i)
        if mid_in.lower() in n.lower():
            mid_in_id = i
            break
    del midi_in
    return mid_in_id

def data2midi(data, mid_out = MID_OUT, buffersize=512, buffertime=0.1, syxtime=1.0):
    midiout = rtmidi.MidiOut()
    mid_out_id = id_mid_out(mid_out)
    if mid_out_id == -1:
        midiout.close_port()
        del midiout
        print("No MIDI Out")
        return False
    else:
        midiout.open_port(mid_out_id)
    
    dd = []
    if LINUX:
        for i in range(len(data)):
            midiout.send_message([data[i]])
            if data[i] == 0xf7:
                time.sleep(syxtime)
            elif (i % buffersize) == (buffersize - 1):
                time.sleep(buffertime)

    else:
        for i in range(len(data)):
            dd.append(data[i])
            if data[i] == 0xf7:
                midiout.send_message(dd)
                time.sleep(syxtime)
                dd = []
        
    midiout.close_port()
    del midiout
    return True

def req2data(req, mid_in = MID_IN, mid_out = MID_OUT):
    mid_in_id = id_mid_in(mid_in)
    mid_out_id = id_mid_out(mid_out)
    midiin = rtmidi.MidiIn()
    midiin.ignore_types(False, True, True)
    if mid_in_id == -1:
        midiin.close_port()
        del midiin
        print("No MIDI In")
        return [], 0
    else:
        midiin.open_port(mid_in_id)
    
    requests=[]
    rq=[]
    for i in req:
        rq.append(i)
        if i==0xf7:
            requests.append(rq)
            rq=[]
    
    data = []
    for req in requests:
        data2midi(req, mid_out)
        # Bankselect messages for DX7II, TX802, YS200
        if req[:3] != [0xf0, 0x43, 0x10]:
            # try to fetch data
            print("Requesting data")
            t0 = time.time()
            while time.time()-t0 < 5:
                d = midiin.get_message()
                if d != None:
                    data += d[0]
                    t0 = time.time()

    midiin.close_port()
    del midiin
    return data, len(data)

def read_cfg(cfg = CFG):
    IN = ''
    OUT = ''
    if os.getenv('MID_IN'):
        IN = os.getenv('MID_IN')
    if os.getenv('MID_OUT'):
        OUT = os.getenv('MID_OUT')
    if os.path.exists(cfg):
        if os.path.exists(CFG):
            with open(CFG, 'r') as f:
                for line in f.readlines():
                    if 'MID_IN' in line:
                        try: IN = line.split('=')[1].strip()
                        except: pass
                    if 'MID_OUT' in line:
                        try: OUT = line.split('=')[1].strip()
                        except: pass
    return IN, OUT

from tkinter import *
class Midiconf:
    def __init__(self):
        if ENABLE_MIDI:

            IN = read_cfg(CFG)[0]
            OUT = read_cfg(CFG)[1]

            midiout = rtmidi.MidiOut()
            midiin = rtmidi.MidiIn()

            self.child = Toplevel()
            self.child.title('MIDI I/O port selection')

            label1 = Label(self.child, text="MID_IN:")
            label1.grid(row=1, column=1, padx=4, pady=4, sticky=W)

            self.mi = Spinbox(self.child, values=[IN]+midiin.get_ports(), wrap=True)
            self.mi.grid(row=1, column=2, columnspan=2, padx=4, pady=4)

            label2 = Label(self.child, text="MID_OUT:")
            label2.grid(row=2, column=1, padx=4, pady=4, sticky=W)
        
            self.mo = Spinbox(self.child, values=[OUT]+midiout.get_ports(), wrap=True)
            self.mo.grid(row=2, column=2, columnspan=2, padx=4, pady=4)
        
            button = Button(self.child, text='OK', width=6, command=self.get_ok)
            button.grid(row=3, column=2, padx=4, pady=4)
        
            button = Button(self.child, text='Cancel', width=6, command=self.child.destroy)
            button.grid(row=3, column=3, padx=4, pady=4)
            return
        else:
            return

    def get_ok(self):
        with open(CFG, 'w') as f:
            f.write('MID_IN = {}\n'.format(self.mi.get()))
            f.write('MID_OUT = {}\n'.format(self.mo.get()))
        self.child.destroy()
        return

