from . import dx7
from . import fourop
from . import fb01
from os import path

def pss2vmem(pss, infile, voicename=''):
    vced = dx7.initvced
    vced[145:155] = [0x20]*10
    vced[134]=4 # Algorithm 5

    BANK=pss[0]+1
    if BANK>5:
        BANK=1
    if voicename:
        NAME = voicename.strip()
        if len(NAME) > 10:
            NAME = NAME.replace(' ','')
            NAME = NAME.ljust(10)[:10]
    else:
        NAME = path.split(infile)[1]
        NAME = path.splitext(NAME)[0]
        NAME = NAME[:8].ljust(8)
        NAME = "{}-{}".format(NAME, BANK)
    for k in range(len(NAME)):
        vced[145+k] = ord(NAME[k])

    FB = (pss[15]>>3)&3
    vced[135] = FB*2
    V = (pss[24]>>7)&1
    PMS = ((pss[16]>>4)&7)*V
    vced[143] = PMS
    AMS = pss[16]&3
    VDT = pss[22]&127
    vced[138] = VDT
    vced[139] = 20 # LPMD
    vced[140] = 20 # LAMD
    vced[142] = 4 #LFW = sin
    S = (pss[24]>>6)&1 #Sustain Enable


    for op in range(2): #0=Modulator 1=Carrier
        dxop = 21*op
        DT1 = (pss[op+1]>>4)&7
        if pss[op+1]>127: 
            DT1 = -1*DT1
        DT2 = (pss[op+9]>>6)&1
        MUL = pss[op+1]&15
        vced[18+dxop] = MUL
        vced[19+dxop] = DT2*50
        vced[20+dxop] = DT1+7

        TL = pss[op+3]&127
        vced[16+dxop] = fb01.out[TL]
        #vced[16+dxop] = max(0, 99-TL)
        
        LKSL = pss[op+5]&15
        LKSH = (pss[op+5]>>4)&15
        RKS = (pss[op+7]>>6)&3
        vced[13+dxop] = 2*RKS

        if LKSL==0:
            vced[11+dxop]=0
        elif LKSL>7: # LC=-LIN
            vced[11+dxop] = 0
            vced[dxop+9] = (LKSL-7)*4
        elif LKSL<8: # LC=+LIN
            vced[11+dxop] = 3
            vced[dxop+9] = (8-LKSL)*4

        if LKSH==0:
            vced[11+dxop] = 0
        elif LKSH<4: # RC=+LIN
            vced[11+dxop] = 3
            vced[op+10] = (4-LKSH)*4
        elif LKSH>10: #RC=-EXP
            vced[11+dxop] = 1
            vced[dxop+10] = (LKSH-10)*4
        elif LKSH>3: #RC=-LIN
            vced[11+dxop] = 0
            vced[dxop+10] = (LKSH-3)*4
        vced[8+dxop] = 27 #BP = C3
        
        AMEN = (pss[op+9]>>7)&1
        vced[14+dxop] = AMS*AMEN

        AR = pss[op+7]&63 # 63?
        D1R = pss[op+9]&63 # 63?
        D2R = pss[op+11]&63 # 63?
        D1L = (pss[op+13]>>4)&15
        RR = pss[op+13]&15
        SRR = pss[op+20]&15
        factor=99./63.
        '''
        vced[0+dxop] = int(factor*AR)
        vced[1+dxop] = int(factor*D1R)
        vced[2+dxop] = int(factor*D2R)
        '''
        vced[0+dxop] = fourop.r1[AR>>1]
        vced[1+dxop] = fourop.r2[D1R>>1]
        vced[2+dxop] = fourop.r3[D2R>>1]
        vced[3+dxop] = fourop.r4[RR]
        vced[4+dxop] = 99
        vced[5+dxop] = fourop.l2[D1L]
        if D2R == 0:
            vced[6+dxop] = fourop.l2[D1L]
        else:
            vced[6+dxop] = 0
        vced[7+dxop] = 0
        # SINTBL = (pss[op+11]>>6)&3

    ''
    vced[42:84] = vced[84:126] = vced[:42]
    vced[58] = vced[79] = vced[100] = vced[121] = 0 #Level op1-4 

    return dx7.vced2vmem(vced)

def pss2vmm(pss, infile, voicename=''):
    vmm = fourop.initvmm
    vmm[57:67] = [0x20]*10

    ALG = 4
    FBL = 2*((pss[15]>>3)&3)
    vmm[40] = ALG + (FBL<<3)

    BANK=pss[0]+1
    if BANK>5:
        BANK=1
    if voicename:
        NAME = voicename.strip()
        if len(NAME) > 10:
            NAME = NAME.replace(' ','')
            NAME = NAME[:10]
    else:
        NAME = path.split(infile)[1]
        NAME = path.splitext(NAME)[0]
        NAME = NAME[:8].ljust(8)
        NAME = "{}-{}".format(NAME, BANK)
    for k in range(len(NAME)):
        vmm[57+k] = ord(NAME[k])

    V = (pss[24]>>7)&1
    PMS = ((pss[16]>>4)&7)*V
    AMS = pss[16]&3
    LFW = 2 #tri
    vmm[45] = (PMS<<5) + (AMS<<3) + LFW

    VDT = pss[22]&127

    vmm[43] = 20 # PMD
    vmm[44] = 20 # AMD
    S = (pss[24]>>6)&1


    for op in range(2):   #0=Modulator 1=Carrier
        txop=(0, 20)[op]   #OP4>OP3
        #txop=(10, 30)[op] #OP2>OP1
        DET = (pss[op+1]>>4)&7
        if pss[op+1]>127: 
            DET = -1*DET
        DET += 3
        RS = (pss[op+7]>>6)&3
        vmm[9+txop] = DET + (RS<<3)
        
        DT2 = (pss[op+9]>>6)&1
        MUL = pss[op+1]&15
        vmm[txop+8] = (0, 1, 4, 5, 8, 9, 10, 14, 
            13, 18, 16, 23, 19, 26, 22, 30, 
        25, 35, 28, 39, 31, 44, 34, 46, 
        26, 49, 40, 52, 42, 55, 45, 58)[2*MUL+DT2] 
    
        TL = pss[op+3]&127
        vmm[txop+7] = int(round(0.74*(127-TL)))
        
        LKSL = pss[op+5]&15
        LKSH = (pss[op+5]>>4)&15
        
        '''
        if LKSL==0:
            vced[11+dxop]=0
        elif LKSL>7: # LC=-LIN
            vced[11+dxop] = 0
            vced[dxop+9] = (LKSL-7)*4
        elif LKSL<8: # LC=+LIN
            vced[11+dxop] = 3
            vced[dxop+9] = (8-LKSL)*4

        if LKSH==0:
            vced[11+dxop] = 0
        elif LKSH<4: # RC=+LIN
            vced[11+dxop] = 3
            vced[op+10] = (4-LKSH)*4
        elif LKSH>10: #RC=-EXP
            vced[11+dxop] = 1
            vced[dxop+10] = (LKSH-10)*4
        elif LKSH>3: #RC=-LIN
            vced[11+dxop] = 0
            vced[dxop+10] = (LKSH-3)*4
        vced[8+dxop] = 27 #BP = C3
        '''

        AME = (pss[op+9]>>7)&1
        vmm[6+txop] = AME<<6


        AR = pss[op+7]&63 # 63?
        D1R = pss[op+9]&63 # 63?
        D2R = pss[op+11]&63 # 63?
        D1L = (pss[op+13]>>4)&15
        RR = pss[op+13]&15
        SRR = pss[op+20]&15
        vmm[0+txop] = AR>>1
        vmm[1+txop] = D1R>>1
        vmm[2+txop] = D2R>>1
        vmm[3+txop] = max(1, RR)
        vmm[4+txop] = D1L
        
    vmm[10:20] = vmm[0:10]
    vmm[30:40] = vmm[20:30]
    vmm[37] = vmm[17] = 0

    # SINTBL --> OSW
    osw4 = osw2 = (pss[op+11]>>6)&3
    osw3 = osw1 = (pss[op+12]>>6)&3
    vmm[74] = osw4<<4
    vmm[76] = osw2<<4
    vmm[78] = osw3<<4
    vmm[80] = osw1<<4

    return vmm

