# Based on C code for FB to DX7 conversion by Sean Bolton
# ported to Python and improved by M.T.

from . import fourop
from . import dx7
from . import dxcommon
from math import log
N = 2.**(1./16.)

#FB INIT VOICE
initfb = [0]*64
initfb[:7] = dxcommon.string2list("SineWav")
initfb[8] = 205 #LFS
initfb[9] = 0b10000000 #LFO Load, AMS
initfb[11] = 0b01111000 #Operator enable
initfb[14] = 0b01000000 #LFW
for opad in (40, 32, 24, 16):
    initfb[opad] = 127
    initfb[opad + 3] = 1  #MUL
    initfb[opad + 4] = 31 #AR
    initfb[opad + 5] = 128 #AM/carrier, D1R
    initfb[opad + 7] = 15 #SL, RR
    initfb[40] = 0 #Operator 1 level

twave = (0x04, 0x06, 0x00, 0x0a)

talg = ( 0x00, 0x0d, 0x07, 0x06, 0x04, 0x15, 0x1e, 0x1f )

dxop1 = ( 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33 )
dxop2 = ( 0x22, 0x22, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22 )
dxop3 = ( 0x11, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11 )
dxop4 = ( 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00 )

tdt = ( 0x38, 0x40, 0x48, 0x50, 0x38, 0x30, 0x28, 0x20 )

tff = ( 0x00, 0x29, 0x39, 0x49 )

#FB->4OP 
out = (98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 
        82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 
        66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 
        50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 
        34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 20, 
        19, 18, 18, 17, 16, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 
        10, 9, 9, 8, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 4, 4, 
        3, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0)

out_tx2fb = (119, 114, 110, 106, 102, 99, 96, 94, 92, 90, 88, 86, 84, 82, 80, 78, 77, 76, 74, 73, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0)

### LFO Speed conversion tables

lfs_4op_dx7 = (
        0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 
        4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
        14, 16, 17, 19, 19, 21, 24, 25, 28, 29, 
        32, 34, 36, 39, 41, 42, 43, 49, 52, 55, 
        58, 60, 63, 64, 65, 66, 66, 67, 67, 67, 
        67, 69, 70, 70, 71, 72, 73, 74, 74, 74, 
        76, 77, 77, 77, 78, 79, 80, 80, 81, 81, 
        82, 83, 83, 84, 86, 86, 87, 88, 88, 90, 
        91, 91, 92, 92, 94, 96, 96, 97, 97, 98, 
        98, 99, 99, 99, 99, 99, 99, 99, 99, 99)

lfs_fb01_dx7 = (
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 
        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 
        3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 
        6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 
        12, 13, 13, 14, 14, 15, 16, 16, 17, 18, 19, 20, 20, 21, 22, 23, 
        24, 25, 27, 28, 29, 30, 32, 33, 35, 36, 38, 39, 41, 43, 45, 47, 
        49, 52, 54, 57, 59, 61, 62, 64, 65, 66, 66, 67, 67, 68, 68, 69, 
        70, 71, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 
        86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 99, 99, 99, 99, 99, 99)

lfsh_fb01_dx7 = (
        1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
        3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 
        5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 
        9, 10, 11, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 34, 35, 37, 
        38, 40, 42, 44, 46, 48, 50, 53, 55, 58, 60, 61, 63, 64, 65, 66, 
        66, 67, 67, 68, 69, 69, 70, 71, 72, 73, 73, 74, 75, 76, 77, 78, 
        80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 91, 92, 94, 95, 97, 98, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
        99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99)

lfs_4op_fb01 = (
        1, 46, 71, 87, 104, 112, 123, 131, 136, 141, 
        146, 151, 155, 158, 163, 165, 169, 171, 173, 176, 
        179, 182, 183, 186, 187, 188, 192, 193, 195, 196, 
        198, 199, 201, 203, 204, 204, 205, 208, 209, 210, 
        211, 212, 214, 215, 216, 217, 218, 219, 220, 220, 
        220, 222, 224, 224, 225, 226, 227, 228, 229, 229, 
        230, 231, 232, 232, 233, 234, 235, 235, 236, 236, 
        236, 237, 237, 239, 240, 240, 241, 242, 242, 244, 
        245, 245, 245, 245, 246, 248, 248, 248, 249, 249, 
        249, 250, 250, 251, 251, 251, 252, 252, 252, 252)

lfsh_4op_fb01 = (
        0, 0, 0, 0, 0, 0, 0, 9, 14, 19, 
        24, 29, 32, 36, 41, 43, 47, 48, 51, 53, 
        57, 60, 61, 64, 64, 66, 70, 71, 73, 74, 
        76, 77, 79, 80, 81, 82, 83, 85, 87, 88, 
        89, 90, 92, 93, 94, 95, 96, 97, 97, 98, 
        98, 100, 101, 101, 103, 104, 105, 106, 107, 107, 
        108, 109, 110, 110, 111, 112, 112, 112, 113, 113, 
        114, 115, 115, 116, 117, 117, 119, 120, 120, 121, 
        122, 122, 123, 123, 124, 125, 125, 126, 126, 127, 
        127, 128, 128, 128, 128, 128, 129, 130, 130, 130)

lfs_fb01_4op = (
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
        3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
        4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 
        5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 
        7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 
        10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 
        13, 14, 14, 14, 14, 15, 15, 15, 16, 16, 17, 17, 18, 18, 18, 19, 
        19, 19, 20, 20, 20, 21, 21, 22, 22, 23, 23, 24, 25, 25, 25, 26, 
        26, 27, 27, 28, 29, 29, 30, 31, 31, 32, 33, 33, 34, 36, 36, 37, 
        37, 38, 39, 40, 41, 41, 42, 43, 44, 45, 46, 47, 49, 49, 51, 51, 
        52, 54, 55, 56, 57, 58, 60, 61, 62, 64, 65, 66, 70, 71, 73, 73, 
        74, 76, 77, 79, 79, 80, 84, 84, 87, 89, 91, 93, 97, 97, 97, 97)

lfsh_fb01_4op = (
        6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 
        8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 
        12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 16, 16, 16, 
        17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 22, 22, 23, 
        23, 24, 25, 25, 26, 26, 26, 27, 28, 28, 29, 29, 30, 31, 32, 32, 
        33, 34, 35, 36, 36, 37, 37, 38, 39, 40, 41, 41, 42, 43, 44, 45, 
        46, 48, 49, 49, 51, 52, 52, 54, 55, 56, 57, 58, 60, 61, 63, 64, 
        65, 68, 70, 72, 73, 74, 74, 76, 77, 79, 80, 82, 84, 85, 87, 89, 
        91, 96, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 
        97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97)



lfs = lfs_fb01_dx7
lfsh = lfsh_fb01_dx7
lfs4 = lfs_fb01_4op
lfsh4 = lfsh_fb01_4op
lfs_fb = lfs_4op_fb01
lfsh_fb = lfsh_4op_fb01

CRS = (0, 1, 2, 3, 4, 5, 6, 7, 
        8, 9, 11, 12, 10, 14, 15, 17, 
        13, 18, 20, 21, 16, 23, 24, 27, 
        19, 26, 29, 32, 22, 30, 33, 37, 
        25, 35, 38, 41, 28, 39, 44, 47, 
        31, 43, 48, 51, 34, 46, 50, 54, 
        36, 49, 53, 57, 40, 52, 56, 60, 
        42, 55, 59, 62, 45, 58, 61, 63)

###

pms_factor = (0, 0.111, 0.122, 0.156, 0.189, 0.232, 0.573, 0.653)

def opconv(fbop, ams):
    dxop=[0]*0x11
    dxop[0] = fourop.r1[fbop[4] & 31]   #R1
    dxop[1] = fourop.r2[fbop[5] & 31]   #R2
    dxop[2] = fourop.r3[fbop[6] & 31]   #R3
    dxop[3] = fourop.r4[fbop[7] & 15]   #R4
    dxop[4] = 99    #L1
    dxop[5] = fourop.l2[15-(fbop[7] >> 4)]   #L2
    D2R = fbop[6]&31
    if D2R==0:
        dxop[6] = dxop[5]
    else:
        dxop[6] = 0
    #dxop[6] = int(dxop[5] * ((31-D2R)/31.0))    #L3
   
    # Level Scaling (needs more testing)
    BP=0
    LC=0
    RC = (0, 3, 1, 2)[((fbop[1]>>7)&1)+((fbop[3]>>6)&2)]
    LD=0
    if (RC==0) or (RC==3): #LIN
        RD = int(round(0.7*((fbop[2]>>4)&15)))
    else: #EXP
        RD = 5*((fbop[2]>>4)&15)
    dxop[10] = RD
    dxop[11] = (RC<<2)+LC

    dxop[12] = tdt[(fbop[3] >> 4) & 7] | (fbop[4] >> 5) #OSC DET, RS

    KVS = (fbop[1]>>4)&7
    AMS = ams * (fbop[5]>>7)
    AMS = (0, 2, 3, 3)[AMS]    # TODO: DX7II_AMS = (0, 2, 4, 5)[AMS]
    dxop[13] = (KVS<<2) + AMS  #KVS, AMS


    #OUT LEVEL
    tl = fbop[0]&127
    tl = min(127, tl+(fbop[2]&15)) #TL adjust (?)
    dxop[14] = out[tl]
    '''
    if (fbop[0] > 99):
        dxop[14] = 0
    else:
        dxop[14] = 99 - fbop[0]
    '''

    dxop[15] = (fbop[3] & 15) << 1 #FCoarse, Mode

    dxop[16] = tff[fbop[6] >> 6]    #FFine
    return dxop



def fb2vmem(fb):
    fb = fbclean(fb)
    dx = dx7.initvmem
    dx[14] = 0
    dx[99] = 0
    dx2 = dx7.initamem

    dx[118:121] = [70, 66, 58] # "FB:"
    for i in range(7):
        dx[i + 121] = fb[i] #NAME

    i = fb[15]
    if (i>127):
        i=i-256
    i += 24
    while (i < 0):
        i += 12
    while (i > 48): 
        i -= 12
    dx[117] = i #TRANSPOSE
    
    # PMS, LFO wave, LFO sync
    PMS = (fb[13]>>4)&7
    LFW = (2, 3, 0, 5)[(fb[14]>>5)&3]
    LFKS = (fb[10]>>7)&1
    dx[116] = (PMS<<4) + (LFW<<1) + LFKS
    
    #dx[115] = int(0.78*(fb[9]&127))  #LAMD
    amd_fb = fb[9]&127
    if amd_fb == 0:
        dx[115] = 0
    else:
        dx[115] = int(round(max(0, min(99, 99 + log(amd_fb/53.4, N)))))

    # LPMD
    PMD = fb[10]&127
    PMD = pms_factor[PMS] * PMD
    PMD = int(round(PMD * 0.78))
    ASGN=fb[59]>>4
    if ASGN == 0:
        dx[114] = PMD
    elif ASGN == 1: #AT PITCH MOD
        dx2[20] = PMD
    elif ASGN == 2: #MW PITCH MOD
        dx2[9] = PMD
    elif ASGN == 3: #BC PITCH MOD
        dx2[16] = PMD
    elif ASGN == 4: #FC PITCH MOD
        dx2[12] = PMD

    # FB-01 range is 0-255
    if LFW == 5: # S/H
        dx[112] = lfsh[fb[8]]
    else:
        dx[112] = lfs[fb[8]]

    dx[111] = (fb[12] >> 3) & 7 #FB

    alg = fb[12] & 7;
    dx[110] = talg[alg] #ALS
    
    dx[dxop1[alg]:dxop1[alg]+17] = opconv(fb[40:48], fb[13]&3)
    dx[dxop2[alg]:dxop2[alg]+17] = opconv(fb[32:40], fb[13]&3)
    dx[dxop3[alg]:dxop3[alg]+17] = opconv(fb[24:32], fb[13]&3)
    dx[dxop4[alg]:dxop4[alg]+17] = opconv(fb[16:24], fb[13]&3)
    
    return dx, dx2

def fb2vmm(fb, yamaha='tx81z'):
    fb = fbclean(fb)
    vmm = fourop.initvmm
    ALG=fb[12]&7
    for op in range(4):
        vmad = (30, 10, 20, 0)[op]
        fbad = (40, 32, 24, 16)[op]
        vmm[0+vmad] = fb[4+fbad]&31    #AR
        vmm[1+vmad] = fb[5+fbad]&31    #D1R
        vmm[2+vmad] = fb[6+fbad]&31    #D2R
        vmm[3+vmad] = max(1, fb[7+fbad]&15)    #RR
        vmm[4+vmad] = 15-(fb[7+fbad]>>4)    #D1L
        vmm[5+vmad] = int(6.6*(fb[2+fbad]>>4))    #LS
        if fb[1+fbad]>>7 == 1: #negative level scaling
            if yamaha  != 'v50':
                vmm[5+vmad] = 0
       
        AME = fb[5+fbad]>>7
        KVS = (fb[1+fbad]>>4)&7
        vmm[6+vmad] = (AME<<6) + KVS
        
        #OUT LEVEL (based on FB_CNVRT for Atari ST)
        tl = fb[fbad]
        if tl<87:
            tl += (fb[2]&15)
        vmm[7 + vmad] = int(round(0.74 * (127 - tl)))

        mul = fb[3+fbad]&15
        ih = fb[6+fbad]>>6
        vmm[8 + vmad] = CRS[4 * mul + ih]
        
        DET = (fb[3+fbad]>>4)&7
        if DET>3:
            DET = -(DET&3)
        DET += 3
        if yamaha == 'v50':
            LS2 = fb[1+fbad]>>7
        else:
            LS2 = 0
        KVS2 = 0
        RS = fb[4+fbad]>>6
        vmm[9+vmad] = (LS2<<6) + (KVS2<<5) + (RS<<3) + DET
    
    FBL = (fb[12]>>3)&7
    SY = 0
    vmm[40] = (SY<<6) + (FBL<<3) + ALG
   
    if (fb[14]>>5) == 3:    #LFW=S/Hold
        vmm[41] = lfsh4[fb[8]]
    else:
        vmm[41] = lfs4[fb[8]]
    
    #vmm[42] = LFD
    PMD = int(0.78*(fb[10]&127)) #PMD
    #vmm[44] = int(0.78*(fb[9]&127))  #AMD
    amd_fb = fb[9] & 127
    if amd_fb == 0:
        vmm[44] = 0
    else:
        vmm[44] = int(round(max(0, min(99, 99 + log(amd_fb/113.66, N)))))
    PMS = (fb[13]>>4)&7
    AMS = fb[13]&3
    LFW = (fb[14]>>5)&3
    vmm[45] = (PMS<<4) + (AMS<<2) + LFW

    TRPS = fb[15]
    if (TRPS>127):
        TRPS -= 256
    TRPS += 24
    while (TRPS < 0):
        TRPS += 12
    while (TRPS > 48): 
        TRPS -= 12
    vmm[46] = TRPS
    vmm[47] = fb[59]&15 #PBR
    vmm[48] = fb[58]>>4 #MONO
    vmm[49] = int(0.78*(fb[58]&127)) #PORT
    ASGN=fb[59]>>4
    if ASGN == 0:
        vmm[43] = PMD
    elif ASGN == 1: #AT PITCH MOD
        vmm[84] = PMD
    elif ASGN == 2: #MW PITCH MOD
        vmm[51] = PMD
    elif ASGN == 3: #BC PITCH MOD
        vmm[53] = PMD
    elif ASGN == 4: #FC PITCH MOD
        vmm[82] = PMD
    vmm[57:67] = [70, 66, 58] + fb[:7]  #FB:VOICENAME

    return vmm


def vmm2fb(vmm):
    fb = initfb
    vmm = fourop.cleanvmm(vmm)
    vmm = fourop.tx81z_dx21(vmm)[0]
    transposed = fourop.tx81z_dx21(vmm)[1]
    vcd, acd, acd2, acd3, efeds, delay = fourop.vmm2vcd(vmm)
    fb[:7] = [32]*7 # NAME
    k = 0
    for i in range(10):
        if vcd[77+i]>32 and k<7:
            fb[k] = vcd[77+i]
            k += 1
    if vcd[59] == 3: #S/H LFS
        fb[8] = lfsh_fb[vcd[54]]
    else: # normal LFS
        fb[8] = lfs_fb[vcd[54]]
    amd = min(127, int(round(113.66 * (N ** (vcd[57] - 99)))))
    fb[9] = 128 + amd # LFO-load-enable AMD
    fb[10] = (vcd[58]<<7) + int(1.28 * vcd[56]) # LFOsync PMD
    fb[11] = 0b01111000 # OPERATOR on/off
    fb[12] = 0b11000000 + (vcd[53]<<3) + vcd[52]  # FBL ALG
    fb[13] = (vcd[60]<<4) + vcd[61] # PMS AMS
    fb[14] = vcd[59]<<5  # LFW
    TRPS = vcd[62] - 24 - transposed
    if TRPS < 0:
        TRPS += 256
    fb[15] = TRPS
    fb[0x3a] = (vcd[63]<<7) + int(1.28 * vcd[66])
    # CTRL = 0 #0=Off #1=ATPM #2=MWPM #3=BCPM #4=FCPM
    if vcd[56]>0:
        CTRL = 0
    else:
        CTRlist = (vcd[56], acd2[0], vcd[71], vcd[73], acd[21])  
        CTRL = CTRlist.index(max(CTRlist))
    fb[0x3b] = (CTRL << 4) + vcd[64]

    for op in range(4):
        vcad = (39, 13, 26, 0)[op]
        acad = (15, 5, 10, 0)[op]
        fbad = (40, 32, 24, 16)[op]
        
        TL = 127 - min(127, int(round(1.54 * vcd[10 + vcad])))
        #TL = out_tx2fb[vcd[10+vcad]]
        
        crs = vcd[(50, 24, 37, 11)[op]] & 63
        crs = CRS.index(crs)
        MUL = (crs >> 2) & 15
        DT2 = crs & 3  #DT2 = IH
        DT1 = (7, 6, 5, 0, 1, 2, 3)[vcd[12 + vcad]] 
        KVS = vcd[9 + vcad]
        if KVS>7: 
            KVS = 0
        LSTYPE0 = (acd2[8] >> (3 - op)) & 1 #LS SIGN
        LSTYPE1 = 0 #LS LINEAR
        LS = int(0.152 * vcd[5 + vcad])
        RS = vcd[6 + vcad] & 3
        TLADJ = 0
        #AME = vcd[8 + vcad] & 1  #!!??
        AME = int(fourop.carrier(vcd[52], op))
        AR = vcd[0 + vcad] & 31
        KVSAR = 0
        D1R = vcd[1 + vcad] & 31
        D2R = vcd[2 + vcad] & 31
        RR = vcd[3 + vcad] & 15
        SL = 15 - vcd[4 + vcad] & 15

        fb[fbad + 0] = TL
        fb[fbad + 1] = (LSTYPE0<<7) + (KVS<<4)
        fb[fbad + 2] = (LS<<4) + TLADJ
        fb[fbad + 3] = (LSTYPE1<<7) + (DT1<<4) + MUL
        fb[fbad + 4] = (RS<<6) + AR
        fb[fbad + 5] = (AME<<7) + (KVSAR<<5) + D1R
        fb[fbad + 6] = (DT2<<6) + D2R
        fb[fbad + 7] = (SL<<4) + RR

    return fblimiter(fb)

def fblimiter(fb):
    alg = fb[12]&7
    cars = 0
    clevel = 0.0
    for op in range(4):
        if fourop.carrier(alg, op) or (op==3):
            cars += 1
            clevel += (127 - fb[(40, 32, 24, 16)[op]])
    clevel /= cars
    maxlevel4 = (105, 106, 107, 105, 108, 109, 108, 110)[alg]
    maxlevel = (126, 125, 125, 125, 119, 115, 118, 112)[alg]
    if clevel > maxlevel:
        for op in range(4):
            if fourop.carrier(alg, op):
                oldlevel = 127 - fb[(40, 32, 24, 16)[op]]
                newlevel = 127 - int(round((maxlevel/clevel) * oldlevel))
                fb[(40, 32, 24, 16)[op]] = newlevel
    fb[16] = max(fb[16], 127 - maxlevel4)

    return fb

def fbclean(fb):
    for i in range(6):
        fb[i] = max(32, fb[i] & 127)
    fb[11] = fb[11] & 0b01111000
    fb[12] = fb[12] & 0b00111111
    fb[13] = fb[13] & 0b01110011
    fb[14] = fb[14] & 0b01100000
    for op in range(4):
        a=16+8*op
        fb[a] = fb[a] & 127
        fb[a+1] = fb[a + 1] & 0b11110000
        fb[a+4] = fb[a + 4] & 0b11011111
        fb[a+6] = fb[a + 6] & 0b11011111
    fb[59] = fb[59] & 127
    return fb

def fb2syx(fbdata, bank=0, channel=0):

    if len(fbdata) == 64:
        syx = [0xf0, 0x43, 0x75, channel, 0x28, 0x00, 0x00]
        syx += [1, 0]
        sumlist = []
        for i in range(64):
            lo = fbdata[i] & 15
            hi = (fbdata[i] >> 4) & 15
            sumlist += [lo, hi]
        syx += sumlist
        syx += [dxcommon.checksum(sumlist)]

    else:
        if (len(fbdata)//64) < 48:
            fbdata += initfb * (48 - len(fbdata)//64)

        fbinfo = "YAMAHA FB-01 VOICEDATA          "
        syx = [0xf0, 0x43, 0x75, channel, 0x00, 0x00, bank]
        syx += [0x00, 0x40]
        sumlist = []
        for i in range(32):
            lo = ord(fbinfo[i]) & 15
            hi = ord(fbinfo[i]) >> 4
            sumlist += [lo, hi]
        syx += sumlist
        syx += [dxcommon.checksum(sumlist)]

        for n in range(48):
            syx += [1, 0]
            sumlist = []
            for i in range(64):
                lo = fbdata[64 * n + i] & 15
                hi = (fbdata[64 * n + i] >> 4) & 15
                sumlist += [lo, hi]
            syx += sumlist
            syx += [dxcommon.checksum(sumlist)]

    syx += [0xf7]
    return syx

def det(detune):
    return ('+0', '+1', '+2', '+3', '-0', '-1', '-2', '-3')[detune]

def fb2txt(fbdata):
    Oo = ('Off', 'On')
    lstyp = ('Lin', 'Exp')
    lssig = ('-', '+')
    s = ''
    if len(fbdata)//64 == 1:
        s += 'YAMAHA FB-01 PARAMETERLIST:\n\n'
        s += 'NAME      : {:>8}\n'.format(dxcommon.list2string(fbdata[:7]))
        s += 'LFO speed : {:>8}\n'.format(fbdata[8])
        s += 'LFO enable: {:>8}\n'.format(fbdata[9] >> 7)
        s += 'AMD       : {:>8}\n'.format(fbdata[9] & 127)
        s += 'LFO sync  : {:>8}\n'.format(fbdata[10] >> 7)
        s += 'PMD       : {:>8}\n'.format(fbdata[10] & 127)
        s += 'FB level  : {:>8}\n'.format(fbdata[12] >> 3 & 7)
        s += 'Algorithm : {:>8}\n'.format(1 + (fbdata[12] & 7))
        s += 'PMS       : {:>8}\n'.format(fbdata[13] >> 4 & 7)
        s += 'AMS       : {:>8}\n'.format(fbdata[13] & 3)
        lfw = ('Saw Up', 'Square', 'Triangle', 'S/Hold')
        s += 'LFW       : {:>8}\n'.format(lfw[fbdata[14] >> 5 & 3])
        trps = fbdata[15]
        if trps>127:
            trps = str(trps - 256)
        else:
            trps = '+' + str(trps)
        s += 'TRPS      : {:>8}\n'.format(trps)
        s += 'MONO      : {:>8}\n'.format(fbdata[58] >> 7)
        s += 'PORT      : {:>8}\n'.format(fbdata[58] & 127)
        s += 'PMD ctrl  : {:>8}\n'.format(fbdata[59] >> 4)
        s += 'PBR       : {:>8}\n\n'.format(fbdata[59] & 15)
        
        s += '                 OP1      OP2      OP3      OP4\n'
        s += 'OP enable : {:>8} {:>8} {:>8} {:>8}\n'.format(Oo[fbdata[11]>>3&1], Oo[fbdata[11]>>4&1], Oo[fbdata[11]>>5&1], Oo[fbdata[11]>>6&1])
        s += '127-TL    : {:>8} {:>8} {:>8} {:>8}\n'.format(127-fbdata[40], 127-fbdata[32], 127-fbdata[24], 127-fbdata[16])
        s += 'TL Adjust : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[42]&15, fbdata[34]&15, fbdata[26]&15, fbdata[18]&15)
        s += 'MUL       : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[43]&15, fbdata[35]&15, fbdata[27]&15, fbdata[19]&15)
        s += 'DT2 (ih)  : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[46]>>6, fbdata[38]>>6, fbdata[30]>>6, fbdata[22]>>6)
        f1 = fourop.freq_4op[CRS[4*(fbdata[43]&15) + (fbdata[46]>>6)]*16]
        f2 = fourop.freq_4op[CRS[4*(fbdata[35]&15) + (fbdata[38]>>6)]*16]
        f3 = fourop.freq_4op[CRS[4*(fbdata[27]&15) + (fbdata[30]>>6)]*16]
        f4 = fourop.freq_4op[CRS[4*(fbdata[19]&15) + (fbdata[22]>>6)]*16]
        s += 'Freq.ratio: {:>8} {:>8} {:>8} {:>8}\n'.format(f1, f2, f3, f4)
        s += 'DT1 (det.): {:>8} {:>8} {:>8} {:>8}\n'.format(det(fbdata[43]>>4&7), det(fbdata[35]>>4&7), det(fbdata[27]>>4&7), det(fbdata[19]>>4&7))
        s += 'LS type   :     {}{}     {}{}     {}{}     {}{}\n'.format(lssig[fbdata[41]>>7],
                lstyp[fbdata[43]>>7], 
                lssig[fbdata[33]>>7], 
                lstyp[fbdata[35]>>7], 
                lssig[fbdata[25]>>7], 
                lstyp[fbdata[27]>>7], 
                lssig[fbdata[17]>>7],
                lstyp[fbdata[19]>>7])
        s += 'LS depth  : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[42]>>4, fbdata[34]>>4, fbdata[26]>>4, fbdata[18]>>4)
        s += 'RS depth  : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[44]>>6, fbdata[36]>>6, fbdata[28]>>6, fbdata[20]>>6)
        s += 'AME       : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[45]>>7, fbdata[37]>>7, fbdata[29]>>7, fbdata[21]>>7)
        s += 'KVS       : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[41]>>4&7, fbdata[33]>>4&7, fbdata[25]>>4&7, fbdata[17]>>4&7) 
        s += 'KVSAR     : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[45]>>5&3, fbdata[37]>>5&3, fbdata[29]>>5&3, fbdata[21]>>5&3)
        s += 'AR        : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[44]&31, fbdata[36]&31, fbdata[28]&31, fbdata[20]&31)
        s += 'D1R       : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[45]&31, fbdata[37]&31, fbdata[29]&31, fbdata[21]&31)
        s += 'D2R       : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[46]&31, fbdata[38]&31, fbdata[30]&31, fbdata[22]&31)
        s += '15-SL     : {:>8} {:>8} {:>8} {:>8}\n'.format(15-(fbdata[47]>>4), 15-(fbdata[39]>>4), 15-(fbdata[31]>>4), 15-(fbdata[23]>>4))
        s += 'RR        : {:>8} {:>8} {:>8} {:>8}\n'.format(fbdata[47]&15, fbdata[39]&15, fbdata[31]&15, fbdata[23]&15)
    else:
        for i in range(len(fbdata)//64):
            s += "{} : {}\n".format(i+1, dxcommon.list2string(fbdata[64*i:64*i+7]))
            if i%48 == 47:
                s += '\n'
    return dxcommon.string2list(s + '\n')


