#!/usr/bin/python
# convert Korg DS8 and 707 fourop FM voicedata
# to Yamaha 4-OP FM voicedata
from . import fourop

def korg7to8(mid):
    nn = len(mid)//8
    dat = [0]*7*nn
    for n in range(nn):
        for b in range(7):
            dat[7*n+b] = mid[8*n+b+1] + ((mid[8*n]<<(7-b)) & 128)
    return dat

def korg8to7(dat):
    nn = (len(dat) + (len(dat)%7))//7
    mid = [0]*8*nn
    for n in range(nn):
        for b in range(7):
            mid[8*n] = (dat[b+7*n]>>7)<<b
            mid[8*n+b+1] = dat[b+7*n] & 127
    return mid

def bnk2vce(bnk):
    vce = [0]*81
    vce[ 0] = bnk[ 0] & 0xb00001111
    vce[ 1] = bnk[ 1] & 0xb00001111
    vce[ 2] = bnk[ 2] & 0xb00000011
    vce[ 3] = bnk[ 3] & 0xb01111111
    vce[ 4] = bnk[ 4] & 0xb00111111
    vce[ 5] = bnk[ 5] & 0xb01111111
    vce[ 6] = bnk[ 6] & 0xb00111111
    vce[ 7] = bnk[ 7] & 0xb00111111
    vce[ 8] = bnk[ 8] & 0xb01111110
    vce[ 9] = bnk[ 9] & 0xb00000011
    vce[10] = (bnk[ 9] & 0xb00011100) >> 2
    vce[11] = bnk[10] & 0xb00000011
    vce[12] = (bnk[10] & 0xb00000100) >> 2
    vce[13] = bnk[11] & 0xb00000011 
    vce[14] = bnk[12] & 0xb00000011
    vce[15] = (bnk[12] & 0xb00011100) >> 2
    vce[16] = bnk[13] & 0xb00000011
    vce[17] = (bnk[13] & 0xb00000100) >> 2
    vce[18] = bnk[14] & 0xb00000011
    vce[19] = bnk[15] & 0xb01111111
    vce[20] = bnk[16] & 0xb00001111
    vce[21] = (bnk[17] & 0xb11000000) >> 6
    vce[22] = bnk[17] & 0xb00011111
    vce[23] = bnk[18] & 0xb00011111 
    vce[24] = bnk[19] & 0xb00001111
    vce[25] = (bnk[19] & 0xb11110000) >> 4
    vce[26] = bnk[20] & 0xb01111111
    vce[27] = bnk[21] & 0xb00001111
    vce[28] = (bnk[22] & 0xb11000000) >> 6
    vce[29] = (bnk[22] & 0xb00011111) >> 5
    vce[30] = bnk[23] & 0xb00011111
    vce[31] = bnk[24] & 0xb00001111
    vce[32] = (bnk[24] & 0xb11110000) >> 4
    vce[33] = bnk[25] & 0xb00111111
    vce[34] = (bnk[26] & 0xb11000000) >> 6
    vce[35] = bnk[26] & 0xb00011111
    vce[36] = bnk[27] & 0xb00011111
    vce[37] = bnk[28] & 0xb00001111
    vce[38] = (bnk[28] & 0xb11110000) >> 4
    vce[39] = bnk[29] & 0xb00111111
    vce[40] = (bnk[30] & 0xb11000000) >> 6
    vce[41] = bnk[30] & 0xb00011111 
    vce[42] = bnk[31] & 0xb00011111
    vce[43] = bnk[32] & 0xb00001111
    vce[44] = (bnk[32] & 0xb11110000) >> 4
    vce[45] = bnk[38] & 0xb00000011
    vce[46] = (bnk[38] & 0xb00001100) >> 2
    vce[47] = (bnk[39] & 0xb10000000) >> 7
    vce[48] = bnk[39] & 0xb00111111
    vce[49] = bnk[43] & 0xb00000111
    vce[50] = bnk[44] & 0xb00000111
    vce[51] = bnk[45] & 0xb00000111
    vce[52] = bnk[46] & 0xb00000111
    vce[53] = (bnk[48] & 0xb10000000) >> 7
    vce[54] = (bnk[48] & 0xb00001000) >> 3
    vce[55] = bnk[48] & 0xb00000011
    vce[56:66] = bnk[49:59] #VOICENAME
    vce[66] = bnk[59] & 0xb00000011
    vce[67] = bnk[33] & 0xb00000011
    vce[68] = bnk[34] & 0xb00111111
    vce[69] = bnk[35] & 0xb00011111
    vce[70] = bnk[36] & 0xb00111111
    vce[71] = bnk[37] & 0xb00111111
    vce[72] = bnk[40] & 0xb00001111
    vce[73] = bnk[41] & 0xb00000011
    vce[74] = (bnk[41] & 0xb00001100) >> 2
    vce[75] = (bnk[41] & 0xb00110000) >> 4
    vce[76] = bnk[42] & 0xb00000011
    vce[77] = bnk[47] & 0xb00000011
    vce[78] = (bnk[47] & 0xb00001100) >> 2
    vce[79] = (bnk[47] & 0xb00110000) >> 4
    vce[80] = (bnk[47] & 0xb11000000) >> 6
    return vce

def bnk2vmm(bnk):
    vce = bnk2vce(bnk)
    return vce2vmm(vce)

def vce2vmm(vce):
    vcd, acd = fourop.initvcd, fourop.initacd
    
    for op in range(4):
        opad = (39, 13, 26, 0)[op]
        apad =(15, 5, 10, 0)[op]
        '''
        vcd[opad] = AR = ATK
        vcd[opad+1] = D1R = DEC
        vcd[opad+2] = D2R = 0
        vcd[opad+3] = RR = REL
        vcd[opad+4] = D1L = SUS
        vcd[opad+5] = LS = KBD
        vcd[opad+6] = RS = KBD
        vcd[opad+7] = EBS = INT
        vcd[opad+8] = AME vce45 vce46
        vcd[opad+9] = KVS = TEG/AEG1/2
        vcd[opad+10] = OUT = LEVL
        vcd[opad+11] = DET

        acd[apad] = FIX
        acd[apad+1] = FIXRG
        acd[apad+2] = FINE
        acd[apad+3] = OSW
        acd[apad+4] = EGSFT
        '''
    '''
    vcd[52] = ALG
    vcd[53] = FBL
    vcd[54] = int(round(vce[68]*63/99) #Frequency | LFS
    vcd[55] = int(round(vce[69]*31/99) #Delay Time | LFD
    vcd[56] = int(round(vce[70)*63/99) #Pitch Intensity | PMD
    vcd[57] = int(round(vce[71]*63/99) #Timbre/Ampl. Intensity | AMD
    vcd[58] = SY
    vcd[59] = vce[67] #LFW
    vcd[60] = PMS
    vcd[61] = AMS
    vcd[62] = 12*vce[66] #TRPS
    
    vcd[63] = vce[53] #MONO
    vcd[64] = PBR
    vcd[65] = PORMOD
    vcd[66] = PORT
    vcd[67] = FC VOL
    vcd[68] = SUS F.SW
    vcd[69] = reserved POR
    vcd[70] = CHORUS
    vcd[71] = MW PITCH
    vcd[72] = MW AMPLI
    vcd[73] = BC PITCH
    vcd[74] = BC AMPLI
    vcd[75] = BC PBIAS
    vcd[76] = BC EBIAS
    '''

    for k in range(56,66): #Voicename
        vce[k] += 32
    vcd[77:87] = vce[56:66] #VOICE NAME

    vmm = fourop.vcd2vmm(vcd, acd)
    
    '''
    vcd[87] = PR1
    vcd[88] = PR2
    vcd[89] = PR3
    vcd[90] = PL1
    vcd[91] = PL2
    vcd[92] = PL3

    acd[20] = REV
    acd[21] = FC PITCH
    acd[22] = FC AMPLI
    '''
    return vmm

