# read .opm files from VOPM OPM synth emulator
# and convert to FB01 format
from . import dxcommon
from . import fourop
import os

def file2data(opmfile):
    with open(opmfile, 'r') as f:
        lines = f.readlines()
   
    data=[]
    p=-1
    for i in range(len(lines)):
        if lines[i][0] == '@':
            p += 1
            nm = lines[i][3+len(str(p)):].strip()
            name = 20*[32] # This is probably more than we really need
            for n in range(min(20, len(nm))):
                name[n] = ord(nm[n])

            for initvoice in ("init      ", "Null      ", "no Name   "):
                n = dxcommon.list2string(name[:10])
                if n.lower() == initvoice.lower():
                    name[:10] = [73, 78, 73, 84, 32, 86, 79, 73, 67, 69] # "INIT VOICE"
                    break
            
            if dxcommon.list2string(name)[:10].lower() == "instrument":
                x = "{:04}".format(int(dxcommon.list2string(name[11:15])))
                newname = os.path.basename(opmfile)[:-4]
                if len(newname)<6:
                    newname += "_"*(6-len(newname))
                newname = newname[:6]+"{}".format(x)
                name[:10] = dxcommon.string2list(newname)

            lfo = lines[i+1][4:].split()
            ch = lines[i+2][4:].split()
            m1 = lines[i+3][4:].split()
            c1 = lines[i+4][4:].split()
            m2 = lines[i+5][4:].split()
            c2 = lines[i+6][4:].split()
            
            # stringnumbers to intnumbers
            for i in range(len(lfo)):
                lfo[i] = int(lfo[i])
            for i in range(len(ch)):
                ch[i] = int(ch[i])
            for i in range(len(m1)):
                m1[i] = int(m1[i])
            for i in range(len(c1)):
                c1[i] = int(c1[i])
            for i in range(len(m2)):
                m2[i] = int(m2[i])
            for i in range(len(c2)):
                c2[i] = int(c2[i])
            
            data += (name+lfo+ch+m1+c1+m2+c2)
    return data

def vopm2fb01(vopm):
    CAR_ADJUST = 8
    MOD_ADJUST = 8
    fb = [0]*64
    fb[0:7] = vopm[0:7] #NAME
    fb[8] = vopm[20]&255 # LFO speed
    fb[9] = vopm[21]&127 # AMD
    fb[10] = vopm[22]&127 #PMD
    fb[11] = vopm[30]&120 #Operator enable
    ALG = vopm[27]&7
    fb[12] = ((vopm[26]&7)<<3) + ALG # FBL, ALG
    fb[13] = (vopm[28]&3) + ((vopm[29]&3)<<4) # AMS, PMS
    fb[14] = (vopm[23]&3)<<5
    fb[15] = 0 #Transpose
    for op in range(4):
        if ((vopm[30]>>(op+3))&1) == 0:
            TL = 127
        else:
            TL = vopm[37+11*op]&127 #TL
        if fourop.carrier(ALG, 3-op):
            TL -= CAR_ADJUST
        else:
            TL -= MOD_ADJUST
        fb[16+8*op] = max(0, min(127, TL))
        fb[1+16+8*op] = 0   # KStype, Velocity sensitivity
        fb[2+16+8*op] = 0   # Level Scaling, TL adjust
        if op in (1, 3):
            pass #fb[2+16+8*op] = 15
        fb[3+16+8*op] = (vopm[39+11*op]&15) + ((vopm[40+11*op]&7)<<4) #MUL, DT1
        fb[4+16+8*op] = (vopm[32+11*op]&31) + ((vopm[38+11*op]&3)<<6) #AR, RS
        fb[5+16+8*op] = (vopm[42+11*op]&128) + (vopm[33+11*op]&31)    #AMS-EN, D1R 
        fb[6+16+8*op] = (vopm[34+11*op]&31) + ((vopm[41+11*op]&3)<<6)  #D2R, DT2
        fb[7+16+8*op] = (vopm[35+11*op]&15) + ((vopm[36+11*op]&15)<<4)   #RR, D1L
    return fb

def fb2vopm(fbdata):
    CAR_ADJUST = -8
    MOD_ADJUST = -8
    opm = '//Converted using TXconvert-{} ({})\r\n'.format(dxcommon.PROGRAMVERSION, dxcommon.PROGRAMDATE)
    opm += '//LFO: LFRQ AMD PMD WF NFRQ\r\n'
    opm += '//@:[Num] [Name]\r\n'
    opm += '//CH: PAN   FL CON AMS PMS SLOT NE\r\n'
    opm += '//[OPname]: AR D1R D2R  RR D1L  TL  KS MUL DT1 DT2 AMS-EN\r\n\r\n'
    for p in range(len(fbdata)//64):
        fb = fbdata[64*p:64*p+64]
        #convert FB01 to VOPM .opm ascii file format
        naam=''
        for i in range(0,7):
            naam += chr(fb[i])
        opm += '@:{} {}\r\n'.format(p, naam)
    
        opm += 'LFO:{:>3} {:>3} {:>3} {:>3} {:>3}\r\n'.format(fb[8], fb[9]&127, fb[10]&127, (fb[14]>>5)&3, 0)
    
        ALG = fb[12]&7
        opm += 'CH:{:>3} {:>3} {:>3} {:>3} {:>3} {:>3} {:>3}\r\n'.format(64, (fb[12]>>3)&7, ALG, fb[13]&3, (fb[13]>>4)&7, 120, 0)


  
        #VOPM does not have a global TRANSPOSE parameter. Try transposing the MUL parameter.
        trps = fb[15]
        muls = [max(0.5, fb[43]&15), max(0.5, fb[35]&15), max(0.5, fb[27]&15), max(0.5, fb[19]&15)]
        if trps > 127:
            trps -= 256
        if trps != 0:
            trpx = (2.**(1./12.))**trps
            for i in range(4):
                muls[i] = round(trpx * muls[i], 1)
            mulvalues = [0.5, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0] * 4
            for x in range(16):
                for y in range(1,4):
                    mulvalues[15*y + x] = round(mulvalues[x] * (1., 1.41, 1.57, 1.73)[y], 1)

            if muls[0] in mulvalues:
                if muls[1] in mulvalues:
                    if muls[2] in mulvalues:
                        if muls[3] in mulvalues:
                            fb[43] = (fb[43]&0xf0) + mulvalues.index(muls[0])%16
                            fb[46] = (fb[46]&31) + ((mulvalues.index(muls[0])//16)<<5)
                        
                            fb[35] = (fb[35]&0xf0) + mulvalues.index(muls[1])%16
                            fb[38] = (fb[38]&31) + ((mulvalues.index(muls[1])//16)<<5)

                            fb[27] = (fb[27]&0xf0) + mulvalues.index(muls[2])%16
                            fb[30] = (fb[30]&31) + ((mulvalues.index(muls[2])//16)<<5)

                            fb[19] = (fb[19]&0xf0) + mulvalues.index(muls[3])%16
                            fb[22] = (fb[22]&31) + ((mulvalues.index(muls[3])//16)<<5)


        for op in range(4):
            opa = 16+8*op
            opn = ('M1:', 'C1:', 'M2:', 'C2:')[op]

            TL = (fb[opa]&127) + (fb[opa+2]&15)
            if fourop.carrier(ALG, 3-op):
                TL -= CAR_ADJUST
            else:
                TL -= MOD_ADJUST
            TL = max(0, min(127, TL))

            opm += '{}{:>3} {:>3} {:>3} {:>3} {:>3} {:>3} {:>3} {:>3} {:>3} {:>3} {:>3}\r\n'.format(opn, fb[opa+4]&31, fb[opa+5]&31, fb[opa+6]&31, fb[opa+7]&15, fb[opa+7]>>4, TL, fb[opa+4]>>6, fb[opa+3]&15, (fb[opa+3]>>4)&7, fb[opa+6]>>6, fb[opa+5]&128)
        opm += '\r\n'
    return dxcommon.string2list(opm)

